---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：94-Sketch Data Structures

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **BloomFilterImplV2の詳細実装**: V2版のint32切り捨て問題修正の詳細コードは未読

## 2) 参照した情報（Evidence一覧）

- E-01: `common/sketch/src/main/java/org/apache/spark/util/sketch/CountMinSketch.java`
- E-02: `common/sketch/src/main/java/org/apache/spark/util/sketch/CountMinSketchImpl.java`
- E-03: `common/sketch/src/main/java/org/apache/spark/util/sketch/BloomFilter.java`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CountMinSketchはdepth*width 2次元配列 | E-02 (line 29: `long[][] table`) | ○ |
| C-02 | CMS width = ceil(2/eps) | E-02 (line 62) | ○ |
| C-03 | CMS depth = ceil(-log1p(-confidence)/log(2)) | E-02 (line 63) | ○ |
| C-04 | CMS PRIME_MODULUS = 2^31 - 1 | E-02 (line 25) | ○ |
| C-05 | CMS Version V1のバイナリ形式 | E-01 (line 56-87) | ○ |
| C-06 | CMS create()ファクトリメソッド2パターン | E-01 (line 207-221) | ○ |
| C-07 | BloomFilter DEFAULT_FPP = 0.03 | E-03 (line 245) | ○ |
| C-08 | BF最適ビット数計算 | E-03 (line 241-243) | ○ |
| C-09 | BF最適ハッシュ関数数計算 | E-03 (line 227-230) | ○ |
| C-10 | BFデフォルトV2版生成 | E-03 (line 288-290) | ○ |
| C-11 | BF readFromのバージョン自動検出 | E-03 (line 195-207) | ○ |
| C-12 | BF Version V1/V2のバイナリ形式 | E-03 (line 47-83) | ○ |
| C-13 | BF mergeInPlace（OR演算） | E-03 (line 137-145) | ○ |
| C-14 | BF intersectInPlace（AND演算） | E-03 (line 147-155) | ○ |
| C-15 | BF mightContainの片側誤差 | E-03 (line 157-161, Javadoc) | ○ |
| C-16 | IncompatibleMergeException | E-01 (line 166-169) | ○ |
| C-17 | BF optimalNumOfBits(n, max, maxBits) | E-03 (line 251-254) | ○ |
| C-18 | BloomFilterImplV2のint32切り捨て修正 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: BloomFilterImplV2.javaの詳細実装コードを直接読み込んでいない。V2のVersionコメント（E-03 line 59-72）からint32切り捨て問題の修正という記述は確認済みだが、具体的な修正方法は未検証
  - 候補：BloomFilterImplV2.java の詳細コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CountMinSketchの計算式はソースコードと完全一致
- 0: 低リスク - BloomFilterのAPI設計はソースコードで確認済み
- 1: 中リスク - V2版の具体的な変更内容は詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] CountMinSketchImplのハッシュ関数実装が正しく記述されているか確認
- [ ] BloomFilterImplV2のint32切り捨て修正の詳細を確認
- [ ] マージ互換性の条件が正確に記述されているか確認
